/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.javaone.anagram;

import java.awt.BorderLayout;
import java.util.logging.Logger;
import org.javaone.anagram.ui.Anagrams;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Top component which displays something.
 */
public final class AnagramGameTopComponent extends TopComponent {

    private static AnagramGameTopComponent instance;

    private static final String PREFERRED_ID = "AnagramGameTopComponent";

    public AnagramGameTopComponent() {
        initComponents();
        anagramPanel.add(new Anagrams().getContentPane(), BorderLayout.CENTER);//TODO:[add] place panel to the TC
        setName(NbBundle.getMessage(AnagramGameTopComponent.class, "CTL_AnagramGameTopComponent"));
        setToolTipText(NbBundle.getMessage(AnagramGameTopComponent.class, "HINT_AnagramGameTopComponent"));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        anagramPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        anagramPanel.setLayout(new java.awt.BorderLayout());
        add(anagramPanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel anagramPanel;
    // End of variables declaration//GEN-END:variables
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized AnagramGameTopComponent getDefault() {
        if (instance == null) {
            instance = new AnagramGameTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the AnagramGameTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized AnagramGameTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(AnagramGameTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof AnagramGameTopComponent) {
            return (AnagramGameTopComponent) win;
        }
        Logger.getLogger(AnagramGameTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID +
                "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
        AnagramGameTopComponent singleton = AnagramGameTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }
}
